/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.AltCallingConvention;
import com.sun.jna.Callback;
import com.sun.jna.CallbackParameterContext;
import com.sun.jna.CallbackProxy;
import com.sun.jna.CallbackResultContext;
import com.sun.jna.CallbackThreadInitializer;
import com.sun.jna.FromNativeContext;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.Function;
import com.sun.jna.FunctionResultContext$CallbackResultContext;
import com.sun.jna.Klass$JNIEnv;
import com.sun.jna.LastErrorException;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.NativeString;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.StringArray;
import com.sun.jna.Structure;
import com.sun.jna.StructureWriteContext$MethodResultContext;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.Union$CallbackResultContext;
import com.sun.jna.Union$PointerType;
import com.sun.jna.WString;
import com.sun.jna.WeakMemoryHolder;
import com.sun.jna.internal.Cleaner;
import java.io.Closeable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import melotr.MCDAClientWindowHelper;
import melotr.MCDARichHelper;

public class CallbackReference
extends WeakReference<Callback>
implements Closeable {
    int callingConvention;
    CallbackProxy proxy;
    Pointer cbstruct;
    static final Map<Pointer, Reference<Callback>[]> pointerCallbackMap;
    static final Map<Callback, CallbackReference> directCallbackMap;
    Pointer trampoline;
    static final Map<Object, Object> allocations;
    Cleaner.Cleanable cleanable;
    private static final Class<?> DLL_CALLBACK_CLASS;
    private static final Map<Long, Reference<CallbackReference>> allocatedMemory;
    static final Map<Callback, CallbackReference> callbackMap;
    Method method;
    private static final Method PROXY_CALLBACK_METHOD;
    private static final Map<Callback, CallbackThreadInitializer> initializers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ ThreadGroup initializeThread(Callback cb, AttachOptions args) {
        CallbackThreadInitializer init = null;
        if (cb instanceof DefaultCallbackProxy) {
            cb = ((DefaultCallbackProxy)cb).getCallback();
        }
        Map<Callback, CallbackThreadInitializer> map = initializers;
        synchronized (map) {
            init = initializers.get(cb);
        }
        ThreadGroup group = null;
        if (init != null) {
            group = init.getThreadGroup(cb);
            args.name = init.getName(cb);
            args.daemon = init.isDaemon(cb);
            args.detach = init.detach(cb);
            args.write();
        }
        return group;
    }

    private static /* synthetic */ boolean isAllowableNativeType(Class<?> cls) {
        return cls == Void.TYPE || cls == Void.class || cls == Boolean.TYPE || cls == Boolean.class || cls == Byte.TYPE || cls == Byte.class || cls == Short.TYPE || cls == Short.class || cls == Character.TYPE || cls == Character.class || cls == Integer.TYPE || cls == Integer.class || cls == Long.TYPE || cls == Long.class || cls == Float.TYPE || cls == Float.class || cls == Double.TYPE || cls == Double.class || Structure.ByValue.class.isAssignableFrom(cls) && Structure.class.isAssignableFrom(cls) || Pointer.class.isAssignableFrom(cls);
    }

    private static /* synthetic */ Reference<Callback>[] addCallbackToArray(Callback cb, Reference<Callback>[] array) {
        int reqArraySize = 1;
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i].get() == null) {
                    array[i] = null;
                    continue;
                }
                ++reqArraySize;
            }
        }
        Reference[] newArray = new Reference[reqArraySize];
        int nidx = 0;
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == null) continue;
                newArray[nidx++] = array[i];
            }
        }
        newArray[nidx] = new WeakReference<Callback>(cb);
        return newArray;
    }

    static Class<?> findCallbackClass(Class<?> type) {
        if (!Callback.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException(type.getName() + LastErrorException.l(Union$PointerType.H("\u2f07\ua725\uf53e\ub48f\u5cf6\u9786\u77de\ub3ad\u5584\u1ec1\u9a65\u93b3\uccd6\ubb49\u3a2e\u105b\ube15\ubb74\uebe4\u405f\ub223\u487e\ucf89\uac7e\u7a59\u0417\ufe55\u2607\ub7cc\ue879\u0fef\ua684\ua64f\u5d53\uaf5d\ua73f\u254f\ucd35\u9e7e\u1c8e\u06e3")));
        }
        if (type.isInterface()) {
            return type;
        }
        Class<?>[] ifaces = type.getInterfaces();
        for (int i = 0; i < ifaces.length; ++i) {
            if (!Callback.class.isAssignableFrom(ifaces[i])) continue;
            try {
                CallbackReference.getCallbackMethod(ifaces[i]);
                return ifaces[i];
            }
            catch (IllegalArgumentException e) {
                break;
            }
        }
        if (Callback.class.isAssignableFrom(type.getSuperclass())) {
            return CallbackReference.findCallbackClass(type.getSuperclass());
        }
        return type;
    }

    private static /* synthetic */ Callback createCallback(Class<?> type, Pointer p) {
        int ctype = AltCallingConvention.class.isAssignableFrom(type) ? 63 : 0;
        HashMap<String, Object> foptions = new HashMap<String, Object>(Native.getLibraryOptions(type));
        foptions.put(FunctionResultContext$CallbackResultContext.p("\ubbb5\uefac\uc731\u3509\ucd98\u24dd\u8afc\uf43b\uc4cb\u24c2\u5fb6\ue285\u2b2d\u97b5\u9b40"), CallbackReference.getCallbackMethod(type));
        NativeFunctionHandler h = new NativeFunctionHandler(p, ctype, foptions);
        return (Callback)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ Pointer getFunctionPointer(Callback cb, boolean direct) {
        Pointer fp = null;
        if (cb == null) {
            return null;
        }
        fp = CallbackReference.getNativeFunctionPointer(cb);
        if (fp != null) {
            return fp;
        }
        Map<String, Object> options = Native.getLibraryOptions(cb.getClass());
        int callingConvention = cb instanceof AltCallingConvention ? 63 : (options != null && options.containsKey(Union$PointerType.H("\u6aed\u2cdd\uae61\u5b70\u2a9d\u913e\u89b0\u4808\ue7b7\u266a\ua043\uc077\u4670\u5c50\u19d3\u734f\u1c1c\u1639")) ? (Integer)options.get(Union$PointerType.H("\u6aed\u2cdd\uae61\u5b70\u2a9d\u913e\u89b0\u4808\ue7b7\u266a\ua043\uc077\u4670\u5c50\u19d3\u734f\u1c1c\u1639")) : 0);
        Map<Callback, CallbackReference> map = direct ? directCallbackMap : callbackMap;
        Map<Pointer, Reference<Callback>[]> map2 = pointerCallbackMap;
        synchronized (map2) {
            CallbackReference cbref = map.get(cb);
            if (cbref == null) {
                cbref = new CallbackReference(cb, callingConvention, direct);
                map.put(cb, cbref);
                pointerCallbackMap.put(cbref.getTrampoline(), CallbackReference.addCallbackToArray(cb, null));
                if (initializers.containsKey(cb)) {
                    cbref.setCallbackOptions(1);
                }
            }
            return cbref.getTrampoline();
        }
    }

    private static /* synthetic */ Method getCallbackMethod(Class<?> cls) {
        Method[] pubMethods = cls.getDeclaredMethods();
        Method[] classMethods = cls.getMethods();
        HashSet<Method> pmethods = new HashSet<Method>(Arrays.asList(pubMethods));
        pmethods.retainAll(Arrays.asList(classMethods));
        Iterator i = pmethods.iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            if (!Callback.FORBIDDEN_NAMES.contains(m.getName())) continue;
            i.remove();
        }
        Method[] methods = pmethods.toArray(new Method[0]);
        if (methods.length == 1) {
            return CallbackReference.checkMethod(methods[0]);
        }
        for (int i2 = 0; i2 < methods.length; ++i2) {
            Method m = methods[i2];
            if (!Union$PointerType.H("\u0989\u543e\u1e7f\uf8fd\ud043\u29eb\u8a9d\u0453").equals(m.getName())) continue;
            return CallbackReference.checkMethod(m);
        }
        String msg = MCDAClientWindowHelper.l(Union$PointerType.H("\u098b\u5455\u1e5d\uf896\ud061\u2980\u8abf\u0438\u8cb7\ufcc1\u37a7\uc9bc\ued65\u1c9c\u7f5e\u3eb1\ube9c\ub890\ue07e\u862a\u3dbc\ucef9\u6d74\uac19\uc699\ucef0\uc82b\u0976\u5c1b\u22c6\u5793\ubc71\ua7a1\uc221\u2cb4\u2fe8\uea3e\u402e\ub06c\u6188\u2ab2\u3301\uee25\u83d1\u701c\ucf0e\ud5c2\udb83\u2bd3\ub5b3\u30c8\u308b\u7c96\u779a\uf06b\uabcb\uf755\uf709\u4cc9\ue5b8\u2b2f\u3123\ub0cb\u561e\u9e60\u90cb\u4818\u3311\u5974\u4d22\u6dd5\uc08a\u3c4a\uca84\uce56\uab99\u1f22\uc70b\u0258\u4626\u4916\u8678\u238c\udc08\ue574"));
        throw new IllegalArgumentException(msg);
    }

    public static Pointer getFunctionPointer(Callback cb) {
        return CallbackReference.getFunctionPointer(cb, false);
    }

    private static /* synthetic */ Pointer getNativeString(Object value, boolean wide) {
        if (value != null) {
            NativeString ns = new NativeString(value.toString(), wide);
            allocations.put(value, ns);
            return ns.getPointer();
        }
        return null;
    }

    private /* synthetic */ Class<?> getNativeType(Class<?> cls) {
        if (Structure.class.isAssignableFrom(cls)) {
            Structure.validate(cls);
            if (!Structure.ByValue.class.isAssignableFrom(cls)) {
                return Pointer.class;
            }
        } else {
            if (NativeMapped.class.isAssignableFrom(cls)) {
                return NativeMappedConverter.getInstance(cls).nativeType();
            }
            if (cls == String.class || cls == WString.class || cls == String[].class || cls == WString[].class || Callback.class.isAssignableFrom(cls)) {
                return Pointer.class;
            }
        }
        return cls;
    }

    private static /* synthetic */ Pointer getNativeFunctionPointer(Callback cb) {
        InvocationHandler handler;
        if (Proxy.isProxyClass(cb.getClass()) && (handler = Proxy.getInvocationHandler(cb)) instanceof NativeFunctionHandler) {
            return ((NativeFunctionHandler)handler).getPointer();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ Callback getCallback(Class<?> type, Pointer p, boolean direct) {
        if (p == null) {
            return null;
        }
        if (!type.isInterface()) {
            throw new IllegalArgumentException(LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\u4d06\u59e6\u7cac\u66ed\u0265\u1d91\u202a\ub713\u384e\u8335\udd38\u6858\ub612\u7f5f\u025d\ua4b4\u444e\uaa3a\ua4ef\u55b0\u0acb\u329a\u08da\u0f17\u36ab\u34d5\u10d2\u8145\u78d5\uab7f\u4ced\u38d7\ub6bd\u1682")));
        }
        Map<Callback, CallbackReference> map = direct ? directCallbackMap : callbackMap;
        Map<Pointer, Reference<Callback>[]> map2 = pointerCallbackMap;
        synchronized (map2) {
            Reference<Callback>[] array = pointerCallbackMap.get(p);
            Callback cb = CallbackReference.getTypeAssignableCallback(type, array);
            if (cb != null) {
                return cb;
            }
            cb = CallbackReference.createCallback(type, p);
            pointerCallbackMap.put(p, CallbackReference.addCallbackToArray(cb, array));
            map.remove(cb);
            return cb;
        }
    }

    static void disposeAll() {
        LinkedList<Reference<CallbackReference>> refs = new LinkedList<Reference<CallbackReference>>(allocatedMemory.values());
        for (Reference reference : refs) {
            CallbackReference ref = (CallbackReference)reference.get();
            if (ref == null) continue;
            ref.close();
        }
    }

    private /* synthetic */ Callback getCallback() {
        return (Callback)this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CallbackThreadInitializer setCallbackThreadInitializer(Callback cb, CallbackThreadInitializer initializer) {
        Map<Callback, CallbackThreadInitializer> map = initializers;
        synchronized (map) {
            if (initializer != null) {
                return initializers.put(cb, initializer);
            }
            return initializers.remove(cb);
        }
    }

    private static /* synthetic */ Callback getTypeAssignableCallback(Class<?> type, Reference<Callback>[] array) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                Callback cb = array[i].get();
                if (cb == null || !type.isAssignableFrom(cb.getClass())) continue;
                return cb;
            }
        }
        return null;
    }

    public Pointer getTrampoline() {
        if (this.trampoline == null) {
            this.trampoline = this.cbstruct.getPointer(0L);
        }
        return this.trampoline;
    }

    private /* synthetic */ void setCallbackOptions(int options) {
        this.cbstruct.setInt(Native.POINTER_SIZE, options);
    }

    @Deprecated
    protected void dispose() {
        this.close();
    }

    @Override
    public void close() {
        if (this.cleanable != null) {
            this.cleanable.clean();
        }
        this.cbstruct = null;
    }

    static {
        callbackMap = new WeakHashMap<Callback, CallbackReference>();
        directCallbackMap = new WeakHashMap<Callback, CallbackReference>();
        pointerCallbackMap = new WeakHashMap<Pointer, Reference<Callback>[]>();
        allocations = Collections.synchronizedMap(new WeakHashMap());
        allocatedMemory = new ConcurrentHashMap<Long, Reference<CallbackReference>>();
        try {
            PROXY_CALLBACK_METHOD = CallbackProxy.class.getMethod(StructureWriteContext$MethodResultContext.u("\u9844\ub4b3\u01d4\u7433\u8bed\u847a\ud3ea\uc434"), Object[].class);
        }
        catch (Exception e) {
            throw new Error(MCDAClientWindowHelper.l(StructureWriteContext$MethodResultContext.u("\u9809\ub482\u01a1\u7412\u8b96\u8419\ud38e\uc412\u6772\uc92f\u3492\u0199\uba67\ua34b\u762e\u23c7\uc4dc\uadef\uab67\u2678\u32e6\ud88b\u20d3\uf9c7\u5b94\ubc9a\u8ca5\u5d7b\u59be\u1d00\u1883\u49b2\u68c2\u509d\ufa9b\u4e70\u715c\u0a06\udc37\u44b7\u0d22\u0f28\u5017\u3075\u1efbH\ub325\ub9af")));
        }
        if (Platform.isWindows()) {
            try {
                DLL_CALLBACK_CLASS = Class.forName(StructureWriteContext$MethodResultContext.u("\u9844\ub4bd\u01d5\u7471\u8bfc\u846e\ud3e7\uc471\u671c\uc908\u34f1\u01fb\uba1c\ua320\u765e\u23a6\uc4a5\uada0\uab29\u267a\u32ad\ud888\u20b8\uf9ea\u5bf8\ubc8a\u8cdd\u5d55\u59c6"));
            }
            catch (ClassNotFoundException e) {
                throw new Error(LastErrorException.l(StructureWriteContext$MethodResultContext.u("\u9809\ub4b2\u01a1\u7422\u8b96\u8429\ud38e\uc422\u677c\uc910\u3492\u01a9\uba67\ua37b\u761f\u23cb\uc4b0\uaddf\uab67\u2648\u32e6\ud8bb\u20d3\uf9f7\u5b94\ubcda\u8cb4\u5d48\u59a7\u1d3a\u18de")), e);
            }
        } else {
            DLL_CALLBACK_CLASS = null;
        }
        initializers = new WeakHashMap<Callback, CallbackThreadInitializer>();
    }

    public static Callback getCallback(Class<?> type, Pointer p) {
        return CallbackReference.getCallback(type, p, false);
    }

    private static /* synthetic */ Method checkMethod(Method m) {
        if (m.getParameterTypes().length > 256) {
            String msg = MCDAClientWindowHelper.l(FunctionResultContext$CallbackResultContext.p("\u6bf9\u589b\u7a1e\u7d50\u2378\u8ec2\u2573\uc059\uc014\u19df\u08a9\u9ba7\u839a\u18cc\u3a86\u22db\ufd02\ufd70\u5056\u4e1a\u0bbe\u9a5a\u799a\u442e\u3e99\u6f75\ue415\ud524\u130b\u81e9\uce03\u99b4\u151c\u461f\ub170\ubdaa\u2f04\u3ee6\u637f\u8f84\u798e\u2f88\u5c24\u32d0\u3307\u4019\u5970\uda9c\u86ce\ubcc2\u2a7b\u2697\u457a\u52c1")) + m;
            throw new UnsupportedOperationException(msg);
        }
        return m;
    }

    private /* synthetic */ CallbackReference(Callback callback, int callingConvention, boolean direct) {
        super(callback);
        TypeMapper mapper = Native.getTypeMapper(callback.getClass());
        this.callingConvention = callingConvention;
        boolean ppc = Platform.isPPC();
        if (direct) {
            Method m = CallbackReference.getCallbackMethod(CallbackReference.findCallbackClass(callback.getClass()));
            Class<?>[] ptypes = m.getParameterTypes();
            for (int i = 0; i < ptypes.length; ++i) {
                if (ppc && (ptypes[i] == Float.TYPE || ptypes[i] == Double.TYPE)) {
                    direct = false;
                    break;
                }
                if (mapper == null || mapper.getFromNativeConverter(ptypes[i]) == null) continue;
                direct = false;
                break;
            }
            if (mapper != null && mapper.getToNativeConverter(m.getReturnType()) != null) {
                direct = false;
            }
        }
        String encoding = Native.getStringEncoding(callback.getClass());
        long peer = 0L;
        if (direct) {
            this.method = CallbackReference.getCallbackMethod(CallbackReference.findCallbackClass(callback.getClass()));
            Class<?>[] nativeParamTypes = this.method.getParameterTypes();
            Class<?> returnType = this.method.getReturnType();
            int flags = 1;
            if (DLL_CALLBACK_CLASS != null && DLL_CALLBACK_CLASS.isInstance(callback)) {
                flags |= 2;
            }
            peer = Native.createNativeCallback(callback, this.method, nativeParamTypes, returnType, callingConvention, flags, encoding);
        } else {
            this.proxy = callback instanceof CallbackProxy ? (CallbackProxy)callback : new DefaultCallbackProxy(CallbackReference.getCallbackMethod(CallbackReference.findCallbackClass(callback.getClass())), mapper, encoding);
            Class<?>[] nativeParamTypes = this.proxy.getParameterTypes();
            Class<?> returnType = this.proxy.getReturnType();
            if (mapper != null) {
                for (int i = 0; i < nativeParamTypes.length; ++i) {
                    FromNativeConverter rc = mapper.getFromNativeConverter(nativeParamTypes[i]);
                    if (rc == null) continue;
                    nativeParamTypes[i] = rc.nativeType();
                }
                ToNativeConverter tn = mapper.getToNativeConverter(returnType);
                if (tn != null) {
                    returnType = tn.nativeType();
                }
            }
            for (int i = 0; i < nativeParamTypes.length; ++i) {
                nativeParamTypes[i] = this.getNativeType(nativeParamTypes[i]);
                if (CallbackReference.isAllowableNativeType(nativeParamTypes[i])) continue;
                String msg = LastErrorException.l(Klass$JNIEnv.n("\uc243\u4181\uf280\ue3ee\u7575\u1f5b\u14b4\u4133\u9cc6\u079f\u7d21\u1764\u4b85\u6fba\u8169\ubea7\uf8ba\u4210")) + nativeParamTypes[i] + MCDAClientWindowHelper.l(Klass$JNIEnv.n("\uc259\u41db\uf2f0\ue3ba\u751b\u1f1a\u14dc\u4174\u9cec\u0797\u7d49\u173f\u4bfa\u6fea\u811a\ubeed\uf897\u420d\u01a2\udc16\uad52\u0739\uca84\u52ca\uf9c6\u2ec6\uaa4e\ue0e7\u2582\u6f2d\u02b5\uc44f"));
                throw new IllegalArgumentException(msg);
            }
            if (!CallbackReference.isAllowableNativeType(returnType = this.getNativeType(returnType))) {
                String msg = LastErrorException.l(Klass$JNIEnv.n("\uc23a\u41f8\uf2f9\ue397\u750c\u1f22\u14cd\u414a\u9cbf\u07f5\u7d4f\u170e\u4bfc\u6fdc\u811b\ube90\uf8c3\u4230\u01ab\udc33\uad17")) + returnType + MCDAClientWindowHelper.l(Klass$JNIEnv.n("\uc259\u41db\uf2f0\ue3ba\u751b\u1f1a\u14dc\u4174\u9cec\u0797\u7d49\u173f\u4bfa\u6fea\u811a\ubeed\uf897\u420d\u01a2\udc16\uad52\u0739\uca84\u52ca\uf9c6\u2ec6\uaa4e\ue0e7\u2582\u6f2d\u02b5\uc44f"));
                throw new IllegalArgumentException(msg);
            }
            int flags = DLL_CALLBACK_CLASS != null && DLL_CALLBACK_CLASS.isInstance(callback) ? 2 : 0;
            peer = Native.createNativeCallback(this.proxy, PROXY_CALLBACK_METHOD, nativeParamTypes, returnType, callingConvention, flags, encoding);
        }
        Pointer pointer = this.cbstruct = peer != 0L ? new Pointer(peer) : null;
        if (peer != 0L) {
            allocatedMemory.put(peer, new WeakReference<CallbackReference>(this));
            this.cleanable = Cleaner.getCleaner().register(this, new CallbackReferenceDisposer(this.cbstruct));
        }
    }

    private static final class CallbackReferenceDisposer
    implements Runnable {
        private Pointer cbstruct;

        public CallbackReferenceDisposer(Pointer cbstruct) {
            this.cbstruct = cbstruct;
        }

        @Override
        public synchronized void run() {
            if (this.cbstruct != null) {
                try {
                    Native.freeNativeCallback(this.cbstruct.peer);
                }
                finally {
                    allocatedMemory.remove(this.cbstruct.peer);
                    this.cbstruct.peer = 0L;
                    this.cbstruct = null;
                }
            }
        }
    }

    private static class NativeFunctionHandler
    implements InvocationHandler {
        private final Function function;
        private final Map<String, ?> options;

        public Pointer getPointer() {
            return this.function;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (Library.Handler.OBJECT_TOSTRING.equals(method)) {
                String str = WeakMemoryHolder.l(Union$PointerType.H("\u1674\u19ec\ue68d\u78de\u907b\ube9a\ue973\u36b0\u1b19\ueb20\u8bbc\u70cf\u3a15\u2af3\u01c6\ue3f1\u2749\u7258\u165e")) + this.function;
                Method m = (Method)this.options.get(Union$PointerType.H("\u1619\u19f3\ue6c0\u78ca\u903d\ubed0\ue920\u36ba\u1b14\ueb2b\u8bff\u70de\u3a48\u2afc\u0193"));
                Class<?> cls = CallbackReference.findCallbackClass(m.getDeclaringClass());
                str = str + MCDARichHelper.l(Union$PointerType.H("\u164a\u19dc")) + cls.getName() + WeakMemoryHolder.l(Union$PointerType.H("\u160d"));
                return str;
            }
            if (Library.Handler.OBJECT_HASHCODE.equals(method)) {
                return this.hashCode();
            }
            if (Library.Handler.OBJECT_EQUALS.equals(method)) {
                Object o = args[0];
                if (o != null && Proxy.isProxyClass(o.getClass())) {
                    return Function.valueOf(Proxy.getInvocationHandler(o) == this);
                }
                return Boolean.FALSE;
            }
            if (Function.isVarArgs(method)) {
                args = Function.concatenateVarArgs(args);
            }
            return this.function.invoke(method.getReturnType(), args, this.options);
        }

        public NativeFunctionHandler(Pointer address, int callingConvention, Map<String, ?> options) {
            this.options = options;
            this.function = new Function(address, callingConvention, (String)options.get(Klass$JNIEnv.n("\u2bc4\u53a8\u63b8\u2594\ubbb0\uac6e\u6e5b\u8180\u472e\u3b11\ub79f\u16d6\u715f\u8517\uea90")));
        }
    }

    private class DefaultCallbackProxy
    implements CallbackProxy {
        private final FromNativeConverter[] fromNative;
        private ToNativeConverter toNative;
        private final String encoding;
        private final Method callbackMethod;

        @Override
        public Class<?> getReturnType() {
            return this.callbackMethod.getReturnType();
        }

        private /* synthetic */ Object invokeCallback(Object[] args) {
            Class<?>[] paramTypes = this.callbackMethod.getParameterTypes();
            Object[] callbackArgs = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                Class<?> type = paramTypes[i];
                Object arg = args[i];
                if (this.fromNative[i] != null) {
                    CallbackParameterContext context = new CallbackParameterContext(type, this.callbackMethod, args, i);
                    callbackArgs[i] = this.fromNative[i].fromNative(arg, context);
                    continue;
                }
                callbackArgs[i] = this.convertArgument(arg, type);
            }
            Object result = null;
            Callback cb = this.getCallback();
            if (cb != null) {
                try {
                    result = this.convertResult(this.callbackMethod.invoke((Object)cb, callbackArgs));
                }
                catch (IllegalArgumentException e) {
                    Native.getCallbackExceptionHandler().uncaughtException(cb, e);
                }
                catch (IllegalAccessException e) {
                    Native.getCallbackExceptionHandler().uncaughtException(cb, e);
                }
                catch (InvocationTargetException e) {
                    Native.getCallbackExceptionHandler().uncaughtException(cb, e.getTargetException());
                }
            }
            for (int i = 0; i < callbackArgs.length; ++i) {
                if (!(callbackArgs[i] instanceof Structure) || callbackArgs[i] instanceof Structure.ByValue) continue;
                ((Structure)callbackArgs[i]).autoWrite();
            }
            return result;
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.callbackMethod.getParameterTypes();
        }

        private /* synthetic */ Object convertResult(Object value) {
            if (this.toNative != null) {
                value = this.toNative.toNative(value, new CallbackResultContext(this.callbackMethod));
            }
            if (value == null) {
                return null;
            }
            Class<?> cls = value.getClass();
            if (Structure.class.isAssignableFrom(cls)) {
                if (Structure.ByValue.class.isAssignableFrom(cls)) {
                    return value;
                }
                return ((Structure)value).getPointer();
            }
            if (cls == Boolean.TYPE || cls == Boolean.class) {
                return Boolean.TRUE.equals(value) ? Function.INTEGER_TRUE : Function.INTEGER_FALSE;
            }
            if (cls == String.class || cls == WString.class) {
                return CallbackReference.getNativeString(value, cls == WString.class);
            }
            if (cls == String[].class || cls == WString[].class) {
                StringArray sa = cls == String[].class ? new StringArray((String[])value, this.encoding) : new StringArray((WString[])value);
                allocations.put(value, sa);
                return sa;
            }
            if (Callback.class.isAssignableFrom(cls)) {
                return CallbackReference.getFunctionPointer((Callback)value);
            }
            return value;
        }

        @Override
        public Object callback(Object[] args) {
            try {
                return this.invokeCallback(args);
            }
            catch (Throwable t) {
                Native.getCallbackExceptionHandler().uncaughtException(this.getCallback(), t);
                return null;
            }
        }

        public DefaultCallbackProxy(Method callbackMethod, TypeMapper mapper, String encoding) {
            this.callbackMethod = callbackMethod;
            this.encoding = encoding;
            Class<?>[] argTypes = callbackMethod.getParameterTypes();
            Class<?> returnType = callbackMethod.getReturnType();
            this.fromNative = new FromNativeConverter[argTypes.length];
            if (NativeMapped.class.isAssignableFrom(returnType)) {
                this.toNative = NativeMappedConverter.getInstance(returnType);
            } else if (mapper != null) {
                this.toNative = mapper.getToNativeConverter(returnType);
            }
            for (int i = 0; i < this.fromNative.length; ++i) {
                if (NativeMapped.class.isAssignableFrom(argTypes[i])) {
                    this.fromNative[i] = new NativeMappedConverter(argTypes[i]);
                    continue;
                }
                if (mapper == null) continue;
                this.fromNative[i] = mapper.getFromNativeConverter(argTypes[i]);
            }
            if (!callbackMethod.isAccessible()) {
                try {
                    callbackMethod.setAccessible(true);
                }
                catch (SecurityException e) {
                    throw new IllegalArgumentException(MCDAClientWindowHelper.l(StructureWriteContext$MethodResultContext.u("\u9c8b\uaf9b\u8da9\u2a9f\u2606\u4ff0\u7830\ube5c\ubeb6\u04eb\ua9d7\u629d\ub0f6\u67e8\ue7a7\uf565\u65b0\ufc4b\u5c0f\u228e\u64ec\uec7b\u1c75\u2000\u5ce4\u6fda\u6024\ud29e\uff79\uea5d\u0dba\u18fc\u1287\u8dbb\u64b4\ufbf2\u7106\u08c6\u506f\u48db\ub770\u90a2\u146b\ubaa6\u3c2b\ufb1b\uead3\u2c80\ua657\u5684\u12c9\u06c6\udc40\ud399\ufc4a\u2192\u5e9a\u0921\u66ca\u89e5\u6f69\u907e\ud0c4\u0f5c\ue986\uc842\u3e84\u670d")) + callbackMethod);
                }
            }
        }

        public Callback getCallback() {
            return CallbackReference.this.getCallback();
        }

        private /* synthetic */ Object convertArgument(Object value, Class<?> dstType) {
            if (value instanceof Pointer) {
                if (dstType == String.class) {
                    value = ((Pointer)value).getString(0L, this.encoding);
                } else if (dstType == WString.class) {
                    value = new WString(((Pointer)value).getWideString(0L));
                } else if (dstType == String[].class) {
                    value = ((Pointer)value).getStringArray(0L, this.encoding);
                } else if (dstType == WString[].class) {
                    value = ((Pointer)value).getWideStringArray(0L);
                } else if (Callback.class.isAssignableFrom(dstType)) {
                    value = CallbackReference.getCallback(dstType, (Pointer)value);
                } else if (Structure.class.isAssignableFrom(dstType)) {
                    if (Structure.ByValue.class.isAssignableFrom(dstType)) {
                        Object s = Structure.newInstance(dstType);
                        byte[] buf = new byte[((Structure)s).size()];
                        ((Pointer)value).read(0L, buf, 0, buf.length);
                        ((Structure)s).getPointer().write(0L, buf, 0, buf.length);
                        ((Structure)s).read();
                        value = s;
                    } else {
                        Object s = Structure.newInstance(dstType, (Pointer)value);
                        ((Structure)s).conditionalAutoRead();
                        value = s;
                    }
                }
            } else if ((Boolean.TYPE == dstType || Boolean.class == dstType) && value instanceof Number) {
                value = Function.valueOf(((Number)value).intValue() != 0);
            }
            return value;
        }
    }

    static class AttachOptions
    extends Structure {
        public String name;
        public boolean detach;
        public boolean daemon;
        public static final List<String> FIELDS = AttachOptions.createFieldsOrder(FromNativeContext.l(Union$PointerType.H("\u1484\u76e3\u0f2f\u36a1\ua01b\ube48")), CallbackThreadInitializer.l(Union$PointerType.H("\u148e\u7684\u0f34\u36ce\ua01d\ube2d")), FromNativeContext.l(Union$PointerType.H("\u148e\u76e3\u0f27\u36a9")));

        @Override
        protected List<String> getFieldOrder() {
            return FIELDS;
        }

        AttachOptions() {
            this.setStringEncoding(CallbackThreadInitializer.l(Union$CallbackResultContext.U("\uc114s\u8372\u4daf")));
        }
    }
}

